import chainer
import chainer.functions as F
import chainer.links as L

import numpy 
import six


def trace(X):
	sum = 0.0
	for i in range(len(X)):
		sum += X[i, i]
	return sum


def kernel_linear(X1, X2):
	n1 = X1.shape[1]
	n2 = X2.shape[1]
	K = F.matmul(X1, X2.transpose(), transa = False, transb = False)
	return K



def kernel_gaussian(X1, X2, sigma):
	n1 = X1.shape[0]
	n2 = X2.shape[0]
	d = X1.shape[1]
	#print(n1, n2, d)
	X1_2 = F.reshape(F.sum(X1 ** 2, axis=1), (n1, 1))
	X2_2 = F.reshape(F.sum(X2 ** 2, axis=1), (n2, 1))


	dist_2 = F.tile(X1_2, (1, n2)) + F.tile(X2_2, (1, n1)).transpose() - \
		2 * F.matmul(X1, X2.transpose())
	K = F.exp(- sigma * dist_2)

	return K



#print("hello, test kernel")
#X1 = numpy.array([[1,1],[2,2],[3,3],[4,4]], dtype=numpy.float32)
#X2 = numpy.array([[5,5],[6,6],[7,7]], dtype=numpy.float32)

#X1 = 0.01 * chainer.Variable(X1)
#X2 = 0.01 * chainer.Variable(X2)

#K = kernel_linear(X1, X2)
#K = kernel_gaussian(X1, X2, 0.1)
#print(K.data)



