function [ lambda_opt, KY_par_opt, w_opt ] = Select_param_IOKR( KX_list_train, Y_train, ky_param, select_param, iokr_param )
%======================================================
% DESCRIPTION:
% Selection of the regularization parameter and of the output kernel parameter(s)
%
% INPUTS:

% KX_list_train:cell array containing the training input kernel matrices
% Y_train:      matrix of size d*n_train containing the training fingerprint vectors
% ky_param:     1*1 struct array containing the information related to the output kernel
% select_param: 1*1 struct array containing information related to the parameter selection 
% iokr_param:   1*1 struct array containing information relative to
%               centering and multiple kernel learning
%
% OUTPUT:
% lambda_opt:   selected regularization parameter
% KY_par_opt:   struct array containing the selected parameter(s) for the output kernel
% w_opt:        MKL weights when using the output kernel with selected parameter(s)
%
%======================================================    

    % Possible values for the regularization parameter
    val_lambda = select_param.lambda;
    
    if strcmp(select_param.cv_type,'cv') && ~isfield(select_param,'cv_partition')
        % Create cross-validation partition if it is missing
        if ~isfield(select_param,'num_folds')
            select_param.num_folds = 10;
        end
        select_param.cv_partition = cvpartition(size(Y_train,2), 'k', select_param.num_folds);
    end
    
    % Generates all possible parameter combinations for the output kernel
    ky_param_all_comb = IterGrid(ky_param);

    mse = zeros(length(val_lambda),length(ky_param_all_comb));
    w = cell(length(ky_param_all_comb), 1);
    for ip = 1:length(ky_param_all_comb)

        % Multiple kernel learning
        KY_train = build_kernel(Y_train, Y_train, ky_param_all_comb(ip));
        w{ip} = mkl_weight(iokr_param.mkl, KX_list_train, normmat(KY_train));
        %w{ip} = disMKL(KX_list_train, normmat(KY_train), 0.001);

        % Input kernels processing and combination
        [KX_train, ~] = input_kernel_preprocessing_train(KX_list_train, w{ip}, iokr_param.center);

        % Computation of the MSE for the different regularization parameters
        mse(:,ip) = IOKR_eval_mse(KX_train, Y_train, ky_param_all_comb(ip), select_param, iokr_param);
        display(mse(:, ip));
    end

    % Parameter seleca tion
    [~, I] = min(mse(:));
    [ind_lambda_opt, ind_KY_param_opt] = ind2sub(size(mse),I);

    lambda_opt = val_lambda(ind_lambda_opt);
    KY_par_opt = ky_param_all_comb(ind_KY_param_opt);
    w_opt = w{ind_KY_param_opt};
    
    disp(['Value selected for the regularization parameter: ' num2str(lambda_opt)])
            
end


