function [ score ] = Test_IOKR(KX_train_test, train_model, Y_train, Y_C_test, iokr_param )
%======================================================
% DESCRIPTION:
% Prediction step of IOKR
%
% INPUTS:
% KX_list_train_test:   cell array containing the input kernel matrices
%                       between the training and the test examples
% KX_list_test:         cell array containing the test input kernel matrices
% train_model:          1*1 struct array containing the regression model
%                       and information on the training data
% Y_train:              matrix of size d*n_train containing the training fingerprints
% Y_C_test:             cell array containing the candidate fingerprints
%                       (each element of the cell array corresponds to a candidate set)
% iokr_param:           1*1 struct array containing information relative to
%                       centering and multiple kernel learning
%
% OUTPUTS:
% score:                cell array containing the scores obtained for each
%                       candidate set
%
%======================================================

    ker_center = iokr_param.center;
    KY_par_opt = train_model.KY_par;
    % Computation of the input kernel between training and test examples
    %KX_train_test = input_kernel_preprocessing_test(KX_list_train_test, KX_list_test, train_model.process_input, ker_center);   
    % Prediction on the test set
    CC = train_model.C;
    B  = CC \ KX_train_test;
    
    % Preprocessing of the training outputs
    switch KY_par_opt.type
        case 'linear'
            Psi_train = norma(Y_train, mean(Y_train,2), ker_center);
            %Y_train_n = norm_vec(Y_train);                       
        otherwise
            
            [~, process_output] = output_kernel_preprocessing_train(Y_train, KY_par_opt, ker_center);
    end

    % Pre-image
    n_test = length(Y_C_test); % number of test examples
    score = cell(n_test,1);
    for j = 1:n_test
        %display(j);
        switch KY_par_opt.type
            case 'linear'
                %Y_C_test_n = norm_vec(Y_C_test{j});
                Psi_Cj = norma(Y_C_test{j}, mean(Y_train,2), ker_center);
                pred = Psi_train * B(:,j);
                tmp = repmat(pred, 1, size(Psi_Cj, 2)) - Psi_Cj;
                tmp = tmp .* tmp;
                %score{j} = sum(tmp, 1);
                
               % dkm
                score{j} = (Psi_train * B(:,j))' * Psi_Cj;
                %score{j} = norm(Psi_train * B(:,j) - Psi_Cj, 'fro');
                %display(['score ' num2str(j) ' ' num2str(score{j})]);B 
                
            otherwise
                
                KY_train_Cj = output_kernel_preprocessing_test(Y_train, Y_C_test{j}, KY_par_opt, process_output, ker_center);

                score{j} = B(:,j)' * KY_train_Cj;
        end
    end
end


