function [w] = disMKL(KX_list, KY, lambda, MAX_LOOP, SG, ETA, ANL, AA, VERBOSE)
%Description:
% Kernel Combination based on Conditional Covariance Operatpr
%
%
if nargin == 3
    MAX_LOOP = 10;
    EPS = 0.0001;
    ETA = 10.0;
    ANL = 4;
    VERBOSE = 1;
    AA = 1.0;
end


n_kx = length(KX_list); % number of input kernels
% Centering input and output training Gram matrices
KX_c = cellfun(@(x) center(x, mean(x, 1), 1), KX_list, 'UniformOutput', false);
KY_c = center(KY, mean(KY, 1), 1);

% w initialization
w = ones(n_kx, 1)./n_kx;

[n_train, n_train] = size(KX_list{1});

EPS = n_train * lambda;
I = eye(n_train, n_train);
KXsum = zeros(n_train, n_train);
dw = zeros(n_kx, 1);
for i = 1:n_kx
    KXsum = KXsum + w(i) .* KX_c{i};
end
    %mz = inv(KXsum + EPS * I);
    %tr = trace(KY_c * mz);
%sgx = MedianDist(KXsum);
sgy = MedianDist(KXsum);
SG = sgy;



A = KXsum + EPS * I;
tr = trace(KY_c * inv(A));
if VERBOSE
    fprintf('\n[%d] tr = %.10f', 0, tr);
end  

eta = ETA;
ax = log(AA)/MAX_LOOP;
% Main loop
pre_tr = 1000;

for h=1:MAX_LOOP
    sg = SG + (ANL - 1) * SG * (MAX_LOOP - h)/MAX_LOOP;
    eta = AA * ETA * exp(-ax * h);
    
    %for i = 1:n_kx
    %    KXsum = KXsum + w(i) .* KX_c{i};
    %end
    %Ksumi = inv(KXsum + EPS.* eye(n_train));
    %KYsumi = KY_c * Ksumi;
    A = KXsum + EPS.* I;
    Ai = inv(A);
    KXsumi = KY_c * Ai;
    for i = 1:n_kx
        dw(i) = trace(Ai * KXsumi * KX_c{i});
    end
    dw = dw .* (EPS/sg);
    
    % Line search
    %mz = inv(KXsum + EPS.* I);
    %mintr = trace(KY_c * mz);
    A = KXsum + EPS.* I;
    Ai = inv(A);
    mintr = trace(KY_c * Ai);
    midx = 0;
    nm = norm(dw);
    for i = 1:3:30
        ee = eta * i / (30 * nm);
        tmpW = w - ee .* dw;
        %tmpW = tmpW./sum(tmpW);
        KXsum = zeros(n_train, n_train);
        for j = 1:n_kx
            KXsum = KXsum + tmpW(j) .* KX_c{j};
        end
        %mz = inv(KXsum + EPS * I);
        %tr = trace(KY_c * mz);
        A = KXsum + EPS * I;
        Ai = inv(A);
        tr = trace(KY_c * Ai);
        if tr < mintr
            mintr = tr;
            midx = i;
        end
        fprintf('current min: %f', mintr);
    end
    ee = eta * midx / (30 * nm);
    w = w - ee * dw;
    %w = w ./ sum(w);
    KXsum = zeros(n_train, n_train);
    for i = 1:n_kx
        KXsum = KXsum + w(i) .* KX_c{i};
    end
    %mz = inv(KXsum + EPS * I);
    %tr = trace(KY_c * mz);
    A = KXsum + EPS * I;
    Ai = inv(A);
    tr = trace(KY_c * Ai);
    
    if VERBOSE
        fprintf('\n[%d] tr = %.10f   eta = %f:%d', h, tr, eta, midx);
    end  
    if abs(pre_tr - tr) < 0.0001
        break
    end
    pre_tr = tr;
      
end
        
        
        
    





