function [params] = myIterGrid(myParams)
%INPUT: 
%OUTPUT: 
% EXAMPLE: 
% >> myParams = struct('lambda', [0.1, 0.2, 0.3], 'gamma', [0.1, 0.2, 0.3])
% >> param = myIterGrid(myParams);
% param(1) corresponds to struct('lambda', 0.1, 'gamma', 0.1)
% param(2) corresponds to struct('lambda', 0.1, 'gamma', 0.2)
% and so on

fields = fieldnames(myParams);
num_fields = length(fields);

values = cell(num_fields, 1);
for i = 1: num_fields
    field_value = myParams.(fields{i});
    values{i} = num2cell(field_value);
end
ix = cellfun(@(x) 1:numel(x), values, 'UniformOutput', false);
[ix{:}] = ndgrid(ix{:});

A = cell(numel(ix{1}), num_fields);
for i = 1:num_fields
    A(:,i) = reshape(values{i}(ix{i}), [], 1);
end
params = cell2struct(A, fields, 2);




