function [ KX_list, Y, inchi, mf, eval ] = load_data_GNPS( datadir )
%======================================================
% DESCRIPTION:
% Load the data
%
% INPUTS:
% datadir: string corresponding to the directory that contains the data
%
% OUTPUTS:
% KX_list:  cell array containing the 24 different input Gram matrices
% Y:        matrix of size d*n containing the fingerprints
% inchi:    vector of length n containing the inchi id of the metabolites
% mf:       vector of length n containing the molecular formula      
% eval:     vector containing the indices of the examples used in the evaluation
%
%======================================================

    disp('Load data')
    
    data_GNPS = load([datadir 'data_GNPS.mat']);
    inchi = data_GNPS.inchi; % inchi id
    mf = data_GNPS.mf; % molecular formula
    Y = full(data_GNPS.fp); % molecular fingerprints

    % Input kernels
    KX_name = {'ALIGND','ALIGN','CEC','CP2Plus','CP2','CPC','CPI','CPJB','CPJ','CPK','CSC',...
    'FIPP','LB','LC','LIPP','LI','LW','NB','NI','NSF','PPKr','RLB','RLI','WPC'};

    n_kx = length(KX_name);
    KX_list = cell(n_kx,1);
    for i = 1:n_kx
        KX_list{i} = load([datadir 'input_kernels/' KX_name{i} '.txt']);
    end

    % Indices of test examples used in the evaluation
    eval = load([datadir 'ind_eval.txt']);

end

